<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-08-24 15:24
 */
interface SellbillofferDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sellbilloffer 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sellbilloffer primary key
 	 */
	public function delete($sellbillid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sellbilloffer sellbilloffer
 	 */
	public function insert($sellbilloffer);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sellbilloffer sellbilloffer
 	 */
	public function update($sellbilloffer);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySellbilldate($value);

	public function queryBySellbillserial($value);

	public function queryBySellbillclientid($value);

	public function queryBySellbilltotaldeptbefor($value);

	public function queryBySellbilltotaldeptafter($value);

	public function queryBySellbilldiscount($value);

	public function queryBySellbilldiscounttype($value);

	public function queryBySellbilltotalbill($value);

	public function queryBySellbillaftertotalbill($value);

	public function queryBySellbilltotalpayed($value);

	public function queryBySellbillfinalbill($value);

	public function queryBySellbillstoreid($value);

	public function queryBySellbillsysdate($value);

	public function queryByComment($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryBySellbillclientname($value);

	public function queryBySellbillsaveid($value);

	public function queryBySellbildirectpayment($value);

	public function queryByBillnameid($value);

	public function queryBySellerid($value);

	public function queryByTempclientName($value);

	public function queryBySellQuantity($value);

	public function queryByDeletedsellid($value);

	public function queryByControlname($value);

	public function queryByTax($value);

	public function queryByCarnumber($value);

	public function queryByCartype($value);

	public function queryByCarchase($value);

	public function queryByCarmotor($value);

	public function queryByCostcenterid($value);

	public function queryByLocaldonw($value);

	public function queryByDailyentryid($value);

	public function queryByObygyVisitId($value);

	public function queryByOnlineOrderId($value);

	public function queryByDelbyuserid($value);

	public function queryByLastReviewType($value);

	public function queryByLastReviewUser($value);

	public function queryByLastReviewDateTime($value);

	public function queryByDelivery($value);

	public function queryByTotalafterdelivery($value);


	public function deleteBySellbilldate($value);

	public function deleteBySellbillserial($value);

	public function deleteBySellbillclientid($value);

	public function deleteBySellbilltotaldeptbefor($value);

	public function deleteBySellbilltotaldeptafter($value);

	public function deleteBySellbilldiscount($value);

	public function deleteBySellbilldiscounttype($value);

	public function deleteBySellbilltotalbill($value);

	public function deleteBySellbillaftertotalbill($value);

	public function deleteBySellbilltotalpayed($value);

	public function deleteBySellbillfinalbill($value);

	public function deleteBySellbillstoreid($value);

	public function deleteBySellbillsysdate($value);

	public function deleteByComment($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteBySellbillclientname($value);

	public function deleteBySellbillsaveid($value);

	public function deleteBySellbildirectpayment($value);

	public function deleteByBillnameid($value);

	public function deleteBySellerid($value);

	public function deleteByTempclientName($value);

	public function deleteBySellQuantity($value);

	public function deleteByDeletedsellid($value);

	public function deleteByControlname($value);

	public function deleteByTax($value);

	public function deleteByCarnumber($value);

	public function deleteByCartype($value);

	public function deleteByCarchase($value);

	public function deleteByCarmotor($value);

	public function deleteByCostcenterid($value);

	public function deleteByLocaldonw($value);

	public function deleteByDailyentryid($value);

	public function deleteByObygyVisitId($value);

	public function deleteByOnlineOrderId($value);

	public function deleteByDelbyuserid($value);

	public function deleteByLastReviewType($value);

	public function deleteByLastReviewUser($value);

	public function deleteByLastReviewDateTime($value);

	public function deleteByDelivery($value);

	public function deleteByTotalafterdelivery($value);


}
?>